<?php
require_once __DIR__ . '/_init.php';
$title = 'Z-Report (ملخص يومي/شِفت)'; include __DIR__.'/_layout_top.php';

$brs = branches($pdo);
$branch_id = param('branch_id','');
$for_date = param('for_date', date('Y-m-d'));
$hasCreated = hasColumn($pdo,'inventory_movements','created_at');

// ملخص مبني على حركات المخزون (بيع/مرتجع بيع) — قيمة التكلفة فقط
$params = [':d' => $for_date];
$where = ["DATE(m.".($hasCreated?'created_at':'id').") = :d"]; // fallback بسيط لو created_at غير متاح
if ($branch_id!==''){ $where[]='m.branch_id=:bid'; $params[':bid']=(int)$branch_id; }
$whereSQL = 'WHERE '.implode(' AND ',$where);

$sql = "
SELECT
  SUM(CASE WHEN m.ref_type='sale' AND m.qty_change<0 THEN -m.qty_change ELSE 0 END) AS units_sold,
  SUM(CASE WHEN m.ref_type='sales_return' AND m.qty_change>0 THEN m.qty_change ELSE 0 END) AS units_returned,
  SUM(CASE WHEN m.ref_type='sale' AND m.qty_change<0 THEN (-m.qty_change * m.unit_cost) ELSE 0 END) AS cogs_value,
  SUM(CASE WHEN m.ref_type='sales_return' AND m.qty_change>0 THEN (m.qty_change * m.unit_cost) ELSE 0 END) AS cogs_back
FROM inventory_movements m
$whereSQL
";
$st=$pdo->prepare($sql); $st->execute($params); $agg=$st->fetch(PDO::FETCH_ASSOC) ?: [];

$units_sold = (int)($agg['units_sold'] ?? 0);
$units_ret  = (int)($agg['units_returned'] ?? 0);
$cogs       = (float)($agg['cogs_value'] ?? 0);
$cogs_back  = (float)($agg['cogs_back'] ?? 0);
$net_units  = $units_sold - $units_ret;
$net_cogs   = $cogs - $cogs_back;

?>
<div class="panel p-3">
  <div class="alert alert-info mb-3">
    هذا التقرير يقدّم **ملخصًا قائمًا على المخزون** (عدد وحدات مباعة/مرتجعة وتكلفة البضاعة). لا يُظهر الإيرادات لأن جداول المبيعات التفصيلية غير مفعّلة بعد.
  </div>
  <form class="row g-2 align-items-end">
    <div class="col-md-4"><label class="form-label">التاريخ</label><input type="date" class="form-control" name="for_date" value="<?= htmlspecialchars($for_date) ?>"></div>
    <div class="col-md-4"><label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id"><option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!==''&&(int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4 d-flex gap-2">
      <button class="btn btn-brand">تحديث</button>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form>
  <hr>
  <div class="row g-3">
    <div class="col-md-3"><div class="panel p-3 text-center"><div class="text-muted">وحدات مباعة</div><div class="fs-5 fw-bold"><?= $units_sold ?></div></div></div>
    <div class="col-md-3"><div class="panel p-3 text-center"><div class="text-muted">وحدات مرتجعة</div><div class="fs-5 fw-bold"><?= $units_ret ?></div></div></div>
    <div class="col-md-3"><div class="panel p-3 text-center"><div class="text-muted">صافي وحدات</div><div class="fs-5 fw-bold"><?= $net_units ?></div></div></div>
    <div class="col-md-3"><div class="panel p-3 text-center"><div class="text-muted">COGS (تكلفة صافية)</div><div class="fs-5 fw-bold"><?= money($net_cogs) ?></div></div></div>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
