<?php
require_once __DIR__ . '/_init.php';
$title='تحويلات بين الفروع'; include __DIR__.'/_layout_top.php';

if (!hasTable($pdo,'transfers') || !hasTable($pdo,'transfer_items')){
  echo '<div class="panel p-3 alert alert-warning">لم يتم تفعيل جدول التحويلات بعد.</div>';
  include __DIR__.'/_layout_bottom.php'; exit;
}

$date_from=param('date_from',''); $date_to=param('date_to',''); $from_id=param('from_branch',''); $to_id=param('to_branch','');
$brs=branches($pdo);
$where=[]; $params=[];
if($date_from!==''){ $where[]="t.transfer_date>=:df"; $params[':df']=$date_from; }
if($date_to!==''){ $where[]="t.transfer_date<=:dt"; $params[':dt']=$date_to; }
if($from_id!==''){ $where[]="t.from_branch_id=:fb"; $params[':fb']=(int)$from_id; }
if($to_id!==''){ $where[]="t.to_branch_id=:tb"; $params[':tb']=(int)$to_id; }
$whereSQL = $where ? 'WHERE '.implode(' AND ',$where) : '';

$sql="SELECT t.id, t.transfer_date, bf.BranchName AS from_branch, bt.BranchName AS to_branch, t.status,
      (SELECT SUM(qty) FROM transfer_items ti WHERE ti.transfer_id=t.id) AS items_count
      FROM transfers t
      LEFT JOIN Branches bf ON bf.BranchID=t.from_branch_id
      LEFT JOIN Branches bt ON bt.BranchID=t.to_branch_id
      $whereSQL
      ORDER BY t.id DESC";
$st=$pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-3"><label class="form-label">من</label><input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($date_from) ?>"></div>
    <div class="col-md-3"><label class="form-label">إلى</label><input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($date_to) ?>"></div>
    <div class="col-md-3"><label class="form-label">من فرع</label><select class="form-select" name="from_branch"><option value="">الكل</option>
      <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $from_id!==''&&(int)$from_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
    </select></div>
    <div class="col-md-3"><label class="form-label">إلى فرع</label><select class="form-select" name="to_branch"><option value="">الكل</option>
      <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $to_id!==''&&(int)$to_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
    </select></div>
    <div class="col-12 d-flex gap-2"><button class="btn btn-brand">تطبيق</button><button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button></div>
  </form><hr>
  <div class="table-responsive">
    <table class="table table-striped text-center">
      <thead class="table-light"><tr><th>#</th><th>التاريخ</th><th>من</th><th>إلى</th><th>الحالة</th><th>عدد البنود</th></tr></thead>
      <tbody>
        <?php if(!$rows): ?><tr><td colspan="6" class="text-muted">لا توجد تحويلات.</td></tr>
        <?php else: foreach($rows as $r): ?>
          <tr class="<?= ($r['status']==='in_transit')?'table-warning':(($r['status']==='completed')?'table-success':'') ?>">
            <td><?= (int)$r['id'] ?></td>
            <td><?= htmlspecialchars($r['transfer_date']) ?></td>
            <td><?= htmlspecialchars($r['from_branch'] ?? '-') ?></td>
            <td><?= htmlspecialchars($r['to_branch'] ?? '-') ?></td>
            <td><?= htmlspecialchars($r['status'] ?? '-') ?></td>
            <td><?= (int)$r['items_count'] ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
