<?php
require_once __DIR__ . '/_init.php';
$title = 'أداء الموردين'; include __DIR__.'/_layout_top.php';

$date_from = param('date_from',''); $date_to = param('date_to','');
$branch_id = param('branch_id',''); $brs = branches($pdo);

$where = ["p.deleted_at IS NULL"]; $params=[];
if($date_from!==''){ $where[]="p.order_date>=:df"; $params[':df']=$date_from; }
if($date_to!==''){ $where[]="p.order_date<=:dt"; $params[':dt']=$date_to; }
if($branch_id!==''){ $where[]="p.branch_id=:bid"; $params[':bid']=(int)$branch_id; }
$whereSQL = 'WHERE '.implode(' AND ', $where);

// 1) Lead time متوسط (invoice_date - order_date)
$sqlLead = "
SELECT s.id AS supplier_id, s.name AS supplier,
       AVG(DATEDIFF(IFNULL(p.invoice_date, p.order_date), p.order_date)) AS avg_lead_days,
       COUNT(*) AS orders_count,
       SUM(p.total) AS purchases_value
FROM purchases p
JOIN suppliers s ON s.id=p.supplier_id
$whereSQL
GROUP BY s.id, s.name
";
$st1=$pdo->prepare($sqlLead); $st1->execute($params); $leadRows=$st1->fetchAll(PDO::FETCH_UNIQUE|PDO::FETCH_ASSOC);

// 2) Fill rate = received_qty / ordered_qty
$sqlFill = "
SELECT s.id AS supplier_id,
       SUM(pi.received_qty) AS rcv, SUM(pi.ordered_qty) AS ord
FROM purchases p
JOIN suppliers s ON s.id=p.supplier_id
JOIN purchase_items pi ON pi.purchase_id=p.id
$whereSQL
GROUP BY s.id
";
$st2=$pdo->prepare($sqlFill); $st2->execute($params); $fillRows=$st2->fetchAll(PDO::FETCH_UNIQUE|PDO::FETCH_ASSOC);

// 3) Return rate = returned_qty / purchased_qty (حسب الكمية)
$sqlRet = "
SELECT s.id AS supplier_id,
       SUM(ri.qty) AS ret_qty
FROM purchase_returns r
JOIN suppliers s ON s.id=r.supplier_id
JOIN purchase_return_items ri ON ri.return_id=r.id
".($date_from||$date_to||$branch_id ? 'WHERE '.implode(' AND ', array_filter([
  $date_from? 'r.return_date>=:rdf' : null,
  $date_to? 'r.return_date<=:rdt' : null,
  $branch_id? 'r.branch_id=:rbid' : null
])) : '')."
GROUP BY s.id
";
$paramsRet=[];
if($date_from!==''){ $paramsRet[':rdf']=$date_from; }
if($date_to!==''){ $paramsRet[':rdt']=$date_to; }
if($branch_id!==''){ $paramsRet[':rbid']=(int)$branch_id; }
$st3=$pdo->prepare($sqlRet); $st3->execute($paramsRet); $retRows=$st3->fetchAll(PDO::FETCH_UNIQUE|PDO::FETCH_ASSOC);

// دمج
$rows=[];
foreach ($leadRows as $sid=>$r){
  $rcv = (float)($fillRows[$sid]['rcv'] ?? 0);
  $ord = (float)($fillRows[$sid]['ord'] ?? 0);
  $fillRate = $ord>0 ? ($rcv/$ord)*100 : null;

  $ret_qty = (float)($retRows[$sid]['ret_qty'] ?? 0);
  $retRate = $rcv>0 ? ($ret_qty/$rcv)*100 : ($ord>0 ? ($ret_qty/$ord)*100 : null);

  $rows[] = [
    'supplier' => $r['supplier'],
    'orders_count' => (int)$r['orders_count'],
    'avg_lead_days' => $r['avg_lead_days']!==null ? round((float)$r['avg_lead_days'], 1) : null,
    'fill_rate' => $fillRate!==null ? round($fillRate,1) : null,
    'return_rate' => $retRate!==null ? round($retRate,1) : null,
    'purchases_value' => (float)$r['purchases_value']
  ];
}
usort($rows, fn($a,$b)=> ($b['purchases_value']<=>$a['purchases_value']));
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-3"><label class="form-label">من</label><input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($date_from) ?>"></div>
    <div class="col-md-3"><label class="form-label">إلى</label><input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($date_to) ?>"></div>
    <div class="col-md-3"><label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id"><option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!=='' && (int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form>
  <hr>
  <div class="table-responsive">
    <table class="table table-hover align-middle text-center">
      <thead class="table-light"><tr>
        <th>المورد</th><th>عدد أوامر الشراء</th><th>متوسط مهلة التوريد (يوم)</th><th>نسبة التوريد (Fill %)</th><th>نسبة المرتجعات %</th><th>قيمة مشتريات</th>
      </tr></thead>
      <tbody>
        <?php if(!$rows): ?><tr><td colspan="6" class="text-muted">لا توجد بيانات.</td></tr>
        <?php else: foreach ($rows as $r): ?>
          <tr>
            <td class="text-start"><?= htmlspecialchars($r['supplier']) ?></td>
            <td><?= (int)$r['orders_count'] ?></td>
            <td><?= $r['avg_lead_days']!==null ? $r['avg_lead_days'] : '—' ?></td>
            <td><?= $r['fill_rate']!==null ? $r['fill_rate'].'%' : '—' ?></td>
            <td><?= $r['return_rate']!==null ? $r['return_rate'].'%' : '—' ?></td>
            <td class="fw-bold"><?= money($r['purchases_value']) ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
