<?php
require_once __DIR__ . '/_init.php';
$title='ملخص المشتريات'; include __DIR__ . '/_layout_top.php';

$date_from = param('date_from',''); $date_to=param('date_to',''); $branch_id=param('branch_id',''); $supplier_id=param('supplier_id','');
$brs=branches($pdo); $sups=suppliers($pdo);

$where=["p.deleted_at IS NULL"]; $params=[];
if($date_from!==''){ $where[]="p.order_date>=:df"; $params[':df']=$date_from; }
if($date_to!==''){ $where[]="p.order_date<=:dt"; $params[':dt']=$date_to; }
if($branch_id!==''){ $where[]="p.branch_id=:bid"; $params[':bid']=(int)$branch_id; }
if($supplier_id!==''){ $where[]="p.supplier_id=:sid"; $params[':sid']=(int)$supplier_id; }
$whereSQL='WHERE '.implode(' AND ',$where);

$sql="SELECT p.id, p.order_date, b.BranchName, s.name AS SupplierName, p.subtotal, p.discount_value, p.tax_rate, p.shipping, p.other_fees, p.total, p.paid
      FROM purchases p
      LEFT JOIN Branches b ON b.BranchID=p.branch_id
      LEFT JOIN suppliers s ON s.id=p.supplier_id
      $whereSQL
      ORDER BY p.id DESC LIMIT 1000";
$st=$pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll(PDO::FETCH_ASSOC);
$sumTotal=$sumPaid=0; foreach($rows as $r){ $sumTotal+=(float)$r['total']; $sumPaid+=(float)$r['paid']; }
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-3"><label class="form-label">من</label><input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($date_from) ?>"></div>
    <div class="col-md-3"><label class="form-label">إلى</label><input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($date_to) ?>"></div>
    <div class="col-md-3"><label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id"><option value="">الكل</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!==''&&(int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select></div>
    <div class="col-md-3"><label class="form-label">المورد</label>
      <select class="form-select" name="supplier_id"><option value="">الكل</option>
        <?php foreach($sups as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $supplier_id!==''&&(int)$supplier_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select></div>
    <div class="col-12 d-flex gap-2"><button class="btn btn-brand">تطبيق</button><button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button></div>
  </form><hr>
  <div class="alert alert-info">إجمالي الفواتير: <b><?= money($sumTotal) ?></b> — المدفوع: <b><?= money($sumPaid) ?></b> — متبقي: <b><?= money($sumTotal-$sumPaid) ?></b></div>
  <div class="table-responsive">
    <table class="table table-striped text-center">
      <thead class="table-light"><tr><th>#</th><th>التاريخ</th><th>المورد</th><th>الفرع</th><th>الإجمالي</th><th>مدفوع</th><th>متبقي</th></tr></thead>
      <tbody>
        <?php if(!$rows): ?><tr><td colspan="7" class="text-muted">لا توجد بيانات.</td></tr>
        <?php else: foreach($rows as $r): $due=(float)$r['total']-(float)$r['paid']; ?>
          <tr class="<?= $due>0?'table-warning':'' ?>">
            <td><?= (int)$r['id'] ?></td>
            <td><?= htmlspecialchars($r['order_date']) ?></td>
            <td><?= htmlspecialchars($r['SupplierName'] ?? '-') ?></td>
            <td><?= htmlspecialchars($r['BranchName'] ?? '-') ?></td>
            <td class="fw-bold"><?= money($r['total']) ?></td>
            <td><?= money($r['paid']) ?></td>
            <td><?= money($due) ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
