<?php
require_once __DIR__ . '/../core/auth.php';
require_login();

$pdo = db();
$success = $error = "";

// بيانات المستخدم الحالي
$currentEmpId = $_SESSION['admin_id'];
$branchId = $_SESSION['branch_id'] ?? 1;

// جلب اليومية المفتوحة للفرع
$daily = $pdo->prepare("SELECT * FROM DailyShifts WHERE BranchID=? AND CloseTime IS NULL ORDER BY ShiftID DESC LIMIT 1");
$daily->execute([$branchId]);
$dailyShift = $daily->fetch();

// جلب كل الشيفتات المفتوحة
$shifts = [];
if ($dailyShift) {
    $stmt = $pdo->prepare("SELECT cs.*, e.EmpName 
                           FROM CashierShifts cs
                           JOIN Employees e ON cs.CashierID = e.EmpID
                           WHERE cs.DailyShiftID=? AND cs.CloseTime IS NULL
                           ORDER BY cs.OpenTime ASC");
    $stmt->execute([$dailyShift['ShiftID']]);
    $shifts = $stmt->fetchAll();
}

// فتح شيفت جديد
if (isset($_POST['open_shift'])) {
    $saleType = $_POST['SaleType'];
    $openingBalance = $_POST['OpeningBalance'] ?: 0;

    if (!$dailyShift) {
        $error = "⚠️ لا يوجد يومية مفتوحة للفرع. افتح اليومية أولاً.";
    } else {
        $stmt = $pdo->prepare("INSERT INTO CashierShifts (DailyShiftID, SaleType, CashierID, OpenTime, OpeningBalance) VALUES (?,?,?,?,?)");
        $stmt->execute([$dailyShift['ShiftID'], $saleType, $currentEmpId, date('Y-m-d H:i:s'), $openingBalance]);
        $success = "✅ تم فتح الشيفت بنجاح.";
        header("Location: cashier_shift.php"); exit;
    }
}

// إغلاق شيفت
if (isset($_POST['close_shift'])) {
    $shiftId = (int) $_POST['ShiftID'];
    $closingBalance = $_POST['ClosingBalance'] ?: 0;

    $stmt = $pdo->prepare("UPDATE CashierShifts SET CloseTime=?, ClosingBalance=? WHERE CashierShiftID=?");
    $stmt->execute([date('Y-m-d H:i:s'), $closingBalance, $shiftId]);
    $success = "✅ تم إغلاق الشيفت.";
    header("Location: cashier_shift.php"); exit;
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إدارة شيفتات الكاشير</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
        body {
      font-family: "Tajawal", Tahoma, Arial, sans-serif;
      background: #f5f7fa;
      margin: 0;
      padding: 0;
    }
    header {
      background: linear-gradient(135deg,#0f2027,#203a43,#2c5364);
      color: #fff;
      padding: 15px 30px;
      display: flex;
      align-items: center;
      justify-content: space-between;
      box-shadow: 0 5px 20px rgba(0,0,0,0.3);
      position: relative;
    }
    header h1 {
      margin: 0;
      font-size: 24px;
      font-weight: bold;
      text-align: center;
      flex: 1;
    }

    /* بيانات المستخدم */
    .user-info {
      display: flex;
      align-items: center;
      gap: 12px;
      background: rgba(255,255,255,0.1);
      padding: 6px 14px;
      border-radius: 50px;
      transition: all 0.3s ease-in-out;
    }
    .user-info:hover {
      background: rgba(255,255,255,0.2);
    }
    .user-info img {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      object-fit: cover;
      border: 2px solid #1abc9c;
    }
    .user-info span {
      font-weight: bold;
      font-size: 14px;
    }
    .user-info a {
      background: #e74c3c;
      border: none;
      color: #fff;
      padding: 5px 12px;
      border-radius: 30px;
      font-size: 13px;
      text-decoration: none;
      transition: background 0.3s;
    }
    .user-info a:hover {
      background: #c0392b;
    }

    /* زر الوضع الليلي */
    #darkSwitch {
      background: #1abc9c;
      color: #fff;
      border: none;
      border-radius: 30px;
      padding: 8px 16px;
      cursor: pointer;
      font-weight: bold;
      transition: all 0.3s;
    }
    #darkSwitch:hover {
      background: #16a085;
    }

    /* الوضع الليلي */
    body.dark {
      background:#121212;
      color:#eee;
    }
    body.dark header {
      background: linear-gradient(135deg,#000,#333);
      border-bottom: 3px solid #1abc9c;
    }
    body.dark .user-info {
      background: rgba(255,255,255,0.1);
    }

    header h1 {
      margin: 0;
      font-size: 22px;
    }

    .container {
      display: flex;
      min-height: calc(100vh - 60px);
    }
    .card { border-radius:15px; box-shadow:0 6px 15px rgba(0,0,0,0.1); margin-bottom:20px; }
    .card-header { background:linear-gradient(135deg,#2c3e50,#3498db); color:#fff; font-weight:bold; }
    .badge-sale { font-size:0.9em; }
  </style>
</head>
<body >
<header>
    <!-- بيانات المستخدم يمين -->
    <div class="user-info">
    <img src="uploads/<?= htmlspecialchars($_SESSION['avatar'] ?? 'default.png') ?>" 
            alt="Avatar" 
            class="rounded-circle border border-2 border-light"
            style="width:40px;height:40px;object-fit:cover;">
      <span><?= htmlspecialchars($_SESSION['admin_username']) ?></span>
      <a href="logout.php"><i class="fa-solid fa-right-from-bracket"></i> خروج</a>
    </div>

    <!-- عنوان الصفحة في الوسط -->
    <h1><i class="fa-solid fa-gauge-high"></i> لوحة التحكم</h1>

    <!-- زر الوضع الليلي شمال -->
    <button id="darkSwitch">🌙</button>
</header>
<div class="text-end mb-3">
  <a href="dashboard.php" class="btn btn-secondary">
    <i class="fa-solid fa-house"></i> الرئيسية
  </a>
</div>
<div class="card">

  <div class="card-header">💼 إدارة شيفتات الكاشير</div>
  <div class="card-body">

    <?php if ($success): ?>
      <div class="alert alert-success text-center"><?= $success ?></div>
    <?php elseif ($error): ?>
      <div class="alert alert-danger text-center"><?= $error ?></div>
    <?php endif; ?>

    <?php if ($dailyShift): ?>
      <h5 class="mb-3">📌 اليومية الحالية: رقم <?= $dailyShift['ShiftID'] ?> (فرع <?= $dailyShift['BranchID'] ?>)</h5>

      <!-- فتح شيفت جديد -->
      <form method="post" class="row g-3 mb-4">
        <div class="col-md-4">
          <label class="form-label">نوع البيع:</label>
          <select name="SaleType" class="form-select" required>
            <option value="">-- اختر --</option>
            <option value="TakeAway">تيك أواي</option>
            <option value="DineIn">صالة</option>
            <option value="Delivery">دليفري</option>
            <option value="CarService">خدمة سيارات</option>
          </select>
        </div>
        <div class="col-md-4">
          <label class="form-label">الرصيد الافتتاحي:</label>
          <input type="number" step="0.01" name="OpeningBalance" class="form-control" value="0">
        </div>
        <div class="col-md-4 d-flex align-items-end">
          <button type="submit" name="open_shift" class="btn btn-success w-100">🚀 فتح شيفت جديد</button>
        </div>
      </form>

      <!-- الشيفتات المفتوحة -->
      <h5 class="mb-3">🔓 الشيفتات المفتوحة حالياً</h5>
      <table class="table table-bordered text-center align-middle">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>الكاشير</th>
            <th>النوع</th>
            <th>وقت الفتح</th>
            <th>الرصيد الافتتاحي</th>
            <th>إغلاق</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($shifts): ?>
            <?php foreach ($shifts as $s): ?>
            <tr>
              <td><?= $s['CashierShiftID'] ?></td>
              <td><?= htmlspecialchars($s['EmpName']) ?></td>
              <td><span class="badge bg-primary badge-sale"><?= $s['SaleType'] ?></span></td>
              <td><?= $s['OpenTime'] ?></td>
              <td><?= number_format($s['OpeningBalance'],2) ?></td>
              <td>
                <form method="post" class="d-flex gap-2">
                  <input type="hidden" name="ShiftID" value="<?= $s['CashierShiftID'] ?>">
                  <input type="number" step="0.01" name="ClosingBalance" class="form-control form-control-sm" placeholder="رصيد ختامي" required>
                  <button type="submit" name="close_shift" class="btn btn-sm btn-danger">🔒 إغلاق</button>
                </form>
              </td>
            </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="6" class="text-muted">لا يوجد شيفتات مفتوحة</td></tr>
          <?php endif; ?>
        </tbody>
      </table>

    <?php else: ?>
      <div class="alert alert-warning text-center">⚠️ لا يوجد يومية مفتوحة للفرع حالياً.</div>
    <?php endif; ?>

  </div>
</div>

</body>
</html>
