<?php
require_once __DIR__ . '/_init.php';
$title = 'تقييم المخزون بسعر البيع'; include __DIR__.'/_layout_top.php';

$brs = branches($pdo);
$branch_id = param('branch_id','');

// --- تحديد أعمدة السعر لكل جدول بشكل مستقل
$pvPriceCols = ['sale_price','retail_price','price']; // أعمدة محتملة في product_variants
$ppPriceCols = ['sale_price','retail_price','price']; // أعمدة محتملة في products

$pvCol = null; // عمود السعر في v=product_variants
$ppCol = null; // عمود السعر في p=products

foreach ($pvPriceCols as $c){
  if (hasColumn($pdo,'product_variants',$c)) { $pvCol=$c; break; }
}
foreach ($ppPriceCols as $c){
  if (hasColumn($pdo,'products',$c)) { $ppCol=$c; break; }
}

if (!$pvCol && !$ppCol){
  echo '<div class="panel p-3 alert alert-warning">لا توجد أعمدة أسعار بيع في <code>product_variants</code> أو <code>products</code> (مثال: <code>sale_price</code> / <code>retail_price</code> / <code>price</code>). أضف عمود سعر للبيع لعرض هذا التقرير.</div>';
  include __DIR__.'/_layout_bottom.php'; exit;
}

// نبني تعبير السعر بحيث لا نذكر عمود غير موجود إطلاقًا
// لو عندنا سعر على مستوى المتغير نستخدمه أولاً، وإلا نلجأ لسعر المنتج إن وجد، وإلا 0.
$priceExpr = $pvCol
  ? "IFNULL(v.`$pvCol`, " . ($ppCol ? "IFNULL(p.`$ppCol`,0)" : "0") . ")"
  : "IFNULL(p.`$ppCol`,0)";

// نص توضيحي للعرض في الواجهة
$usedColsText = $pvCol ? "v.$pvCol" . ($ppCol ? " ← fallback: p.$ppCol" : "") : "p.$ppCol";

// الفلاتر
$params=[]; $where=[];
if ($branch_id!==''){ $where[]='s.branch_id=:bid'; $params[':bid']=(int)$branch_id; }
$whereSQL = $where ? 'WHERE '.implode(' AND ',$where) : '';

// الاستعلام
$sql = "
SELECT b.BranchName,
       SUM(s.quantity) AS total_qty,
       SUM(s.quantity * $priceExpr) AS retail_value
FROM product_variant_stock s
JOIN product_variants v ON v.id=s.variant_id
JOIN products p ON p.id=v.product_id
LEFT JOIN Branches b ON b.BranchID=s.branch_id
$whereSQL
GROUP BY b.BranchName
ORDER BY retail_value DESC
";
$st=$pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll(PDO::FETCH_ASSOC);

// الإجمالي
$total=0; foreach($rows as $r){ $total += (float)$r['retail_value']; }
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-4">
      <label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id">
        <option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?>
          <option value="<?= (int)$id ?>" <?= $branch_id!=='' && (int)$branch_id===$id ? 'selected' : ''; ?>>
            <?= htmlspecialchars($nm) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-8 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form>
  <hr>
  <div class="alert alert-info">
    إجمالي قيمة المخزون بسعر البيع:
    <strong><?= money($total) ?></strong>
    <small class="text-muted">(الأعمدة المستخدمة: <?= htmlspecialchars($usedColsText) ?>)</small>
  </div>
  <div class="table-responsive">
    <table class="table table-hover text-center">
      <thead class="table-light">
        <tr><th>الفرع</th><th>إجمالي الكمية</th><th>قيمة البيع</th></tr>
      </thead>
      <tbody>
        <?php if(!$rows): ?>
          <tr><td colspan="3" class="text-muted">لا توجد بيانات.</td></tr>
        <?php else: foreach($rows as $r): ?>
          <tr>
            <td><?= htmlspecialchars($r['BranchName'] ?? '-') ?></td>
            <td><?= (int)$r['total_qty'] ?></td>
            <td class="fw-bold"><?= money($r['retail_value']) ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
