<?php
require_once __DIR__ . '/_init.php';
$title = 'المخزون الحالي';
include __DIR__ . '/_layout_top.php';

$branch_id = param('branch_id','');
$cat_id = param('category_id','');
$q = param('q','');
$show0 = isset($_GET['show_zero']);
$brs = branches($pdo); $cats = categories($pdo);

$where = ["v.deleted_at IS NULL"];
$params = [];
if ($branch_id!==''){ $where[]="s.branch_id=:bid"; $params[':bid']=(int)$branch_id; }
if ($cat_id!==''){ $where[]="p.category_id=:cid"; $params[':cid']=(int)$cat_id; }
if ($q!==''){ $where[]="(v.sku LIKE :q OR p.name_ar LIKE :q)"; $params[':q']="%$q%"; }
if (!$show0){ $where[]="s.quantity>0"; }
$whereSQL = $where ? 'WHERE '.implode(' AND ',$where) : '';

$sql = "SELECT p.name_ar AS product_name, v.sku, s.quantity, s.min_quantity, b.BranchName
        FROM product_variant_stock s
        JOIN product_variants v ON v.id=s.variant_id
        JOIN products p ON p.id=v.product_id
        LEFT JOIN Branches b ON b.BranchID=s.branch_id
        $whereSQL
        ORDER BY p.name_ar, v.sku, b.BranchName";
$st = $pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll(PDO::FETCH_ASSOC);

if (isset($_GET['export']) && $_GET['export']==='csv'){
  csv_export('stock_current.csv',['product_name','sku','BranchName','quantity','min_quantity'],$rows);
}
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-3"><label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id">
        <option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!=='' && (int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3"><label class="form-label">الفئة</label>
      <select class="form-select" name="category_id">
        <option value="">كل الفئات</option>
        <?php foreach($cats as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $cat_id!=='' && (int)$cat_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3"><label class="form-label">بحث</label>
      <input class="form-control" name="q" value="<?= htmlspecialchars($q) ?>" placeholder="الاسم/الباركود SKU">
    </div>
    <div class="col-md-2 form-check ms-2">
      <input class="form-check-input" type="checkbox" id="show_zero" name="show_zero" <?= $show0?'checked':''; ?>>
      <label class="form-check-label" for="show_zero">عرض الأصناف الصفرية</label>
    </div>
    <div class="col-md-12 d-flex gap-2">
      <button class="btn btn-brand"><i class="fa-solid fa-magnifying-glass"></i> تطبيق</button>
      <a class="btn btn-outline-secondary" href="stock_current.php">مسح</a>
      <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>"><i class="fa-solid fa-file-csv"></i> تصدير CSV</a>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()"><i class="fa-solid fa-print"></i> طباعة</button>
    </div>
  </form>
  <hr>
  <div class="table-responsive">
    <table class="table table-hover align-middle text-center">
      <thead class="table-light"><tr>
        <th>الصنف</th><th>SKU</th><th>الفرع</th><th>المخزون</th><th>حدّ أدنى</th><th>حالة</th>
      </tr></thead>
      <tbody>
        <?php if(!$rows): ?>
          <tr><td colspan="6" class="text-muted">لا توجد بيانات.</td></tr>
        <?php else: foreach($rows as $r): $need = ((int)$r['quantity'] <= (int)$r['min_quantity']); ?>
          <tr class="<?= $need?'table-warning':'' ?>">
            <td class="text-start"><?= htmlspecialchars($r['product_name']) ?></td>
            <td><?= htmlspecialchars($r['sku']) ?></td>
            <td><?= htmlspecialchars($r['BranchName'] ?? '-') ?></td>
            <td><strong><?= (int)$r['quantity'] ?></strong></td>
            <td><?= (int)$r['min_quantity'] ?></td>
            <td><?= $need? '<span class="badge bg-warning text-dark">تحت الحد</span>':'<span class="badge bg-success">جيد</span>' ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/_layout_bottom.php';
