<?php
require_once __DIR__.'/_init.php';
$title='ملخص المبيعات';
include __DIR__.'/_layout_top.php';

$df = param('date_from','');
$dt = param('date_to','');
$branch_id = param('branch_id','');
$brs = branches($pdo);

$hasSales     = hasTable($pdo,'sales');
$hasSaleItems = hasTable($pdo,'sale_items');
$hasSalesRet  = hasTable($pdo,'sales_returns');
$hasDaily     = hasTable($pdo,'dailyshiftsales');

/** تحديد عمود التاريخ في sales */
$dateCol = null;
foreach (['created_at','invoice_date','sale_date'] as $c) {
  if ($hasSales && hasColumn($pdo,'sales',$c)) { $dateCol=$c; break; }
}

/** تحديد عمود الإجمالي في sales */
$salesTotalCol = null;
if ($hasSales) {
  foreach (['total','grand_total','net_total','final_total','total_amount'] as $c) {
    if (hasColumn($pdo,'sales',$c)) { $salesTotalCol=$c; break; }
  }
}

/** مصفوفة النتائج */
$sum = [
  'sales'=>0.0,
  'returns'=>0.0,
  'net'=>0.0,
  'count_invoices'=>0,
  'items'=>0,
  'avg_invoice'=>0.0,
  'avg_items'=>0.0
];

if ($hasSales && $dateCol && $salesTotalCol){
  /** شروط الاستعلام على sales */
  $w = [];
  $p = [];

  // حذف منطقي إن وُجد
  if (hasColumn($pdo,'sales','deleted_at')) {
    $w[] = "s.deleted_at IS NULL";
  }
  // الفلاتر الزمنية
  if ($df!==''){ $w[]="DATE(s.`$dateCol`) >= :df"; $p[':df']=$df; }
  if ($dt!==''){ $w[]="DATE(s.`$dateCol`) <= :dt"; $p[':dt']=$dt; }

  // الفرع إن وُجد العمود
  if ($branch_id!=='' && hasColumn($pdo,'sales','branch_id')){
    $w[]="s.branch_id=:bid"; $p[':bid']=(int)$branch_id;
  }

  $wsql = $w ? 'WHERE '.implode(' AND ',$w) : '';

  /** إجمالي المبيعات وعدد الفواتير */
  $st = $pdo->prepare("
    SELECT COUNT(*) AS cnt, COALESCE(SUM(s.`$salesTotalCol`),0) AS total
    FROM sales s
    $wsql
  ");
  $st->execute($p);
  $row = $st->fetch(PDO::FETCH_ASSOC) ?: ['cnt'=>0,'total'=>0];
  $sum['sales'] = (float)$row['total'];
  $sum['count_invoices'] = (int)$row['cnt'];

  /** إجمالي المرتجعات (إن وُجد جدول المرتجعات) */
  if ($hasSalesRet){
    // تحديد تاريخ المرتجع لو موجود
    $retDateCol=null; foreach(['created_at','return_date'] as $c){ if(hasColumn($pdo,'sales_returns',$c)){ $retDateCol=$c; break; } }
    // تحديد عمود الإجمالي في المرتجعات
    $retTotalCol=null; foreach(['total','grand_total','net_total','total_amount'] as $c){ if(hasColumn($pdo,'sales_returns',$c)){ $retTotalCol=$c; break; } }

    if ($retTotalCol){
      $wr=[]; $pr=[];

      if ($retDateCol){
        if ($df!==''){ $wr[]="DATE(r.`$retDateCol`) >= :df"; $pr[':df']=$df; }
        if ($dt!==''){ $wr[]="DATE(r.`$retDateCol`) <= :dt"; $pr[':dt']=$dt; }
      }
      if ($branch_id!=='' && hasColumn($pdo,'sales_returns','branch_id')){ $wr[]="r.branch_id=:bid"; $pr[':bid']=(int)$branch_id; }
      if (hasColumn($pdo,'sales_returns','deleted_at')){ $wr[]="r.deleted_at IS NULL"; }

      $wrSql = $wr ? 'WHERE '.implode(' AND ',$wr) : '';
      $rt = $pdo->prepare("SELECT COALESCE(SUM(r.`$retTotalCol`),0) FROM sales_returns r $wrSql");
      $rt->execute($pr);
      $sum['returns'] = (float)$rt->fetchColumn();
    }
  }

  /** إجمالي كميات البنود */
  if ($hasSaleItems){
    // تحديد اسم عمود الكمية فعليًا في جدول sale_items
    $qtyCol = null;
    foreach (['quantity','qty','qty_sold','quantity_sold','pieces','units','count'] as $c) {
      if (hasColumn($pdo, 'sale_items', $c)) { $qtyCol = $c; break; }
    }
    // لو ما لقيناش عمود كمية، نستخدم COUNT(*) كبديل (عدد الصفوف)
    $expr = $qtyCol ? "COALESCE(SUM(i.`$qtyCol`),0)" : "COUNT(*)";

    // شرط حذف منطقي على عناصر الفاتورة إن وُجد
    $iw = '';
    if (hasColumn($pdo, 'sale_items', 'deleted_at')) {
      $iw = $wsql ? " AND i.deleted_at IS NULL" : " WHERE i.deleted_at IS NULL";
    }

    $st = $pdo->prepare("
      SELECT $expr
      FROM sale_items i
      JOIN sales s ON s.id = i.sale_id
      $wsql$iw
    ");
    $st->execute($p);
    $sum['items'] = (int)$st->fetchColumn();
  }

} elseif ($hasDaily) {
  // بديل تقريبي من dailyshiftsales
  $w=[]; $p=[];
  if ($df!==''){ $w[]="DATE(created_at) >= :df"; $p[':df']=$df; }
  if ($dt!==''){ $w[]="DATE(created_at) <= :dt"; $p[':dt']=$dt; }
  $wsql = $w? 'WHERE '.implode(' AND ',$w):'';
  $st=$pdo->prepare("SELECT
      COALESCE(SUM(CASE WHEN type='sale' THEN amount ELSE 0 END),0) AS sales,
      COALESCE(SUM(CASE WHEN type='return' THEN amount ELSE 0 END),0) AS returns,
      COUNT(CASE WHEN type='sale' THEN 1 END) AS cnt
    FROM dailyshiftsales $wsql");
  $st->execute($p);
  $r=$st->fetch(PDO::FETCH_ASSOC) ?: ['sales'=>0,'returns'=>0,'cnt'=>0];
  $sum['sales']=(float)$r['sales']; $sum['returns']=(float)$r['returns']; $sum['count_invoices']=(int)$r['cnt'];
}

/** الحسابات المشتقة */
$sum['net'] = $sum['sales'] - $sum['returns'];
$sum['avg_invoice'] = $sum['count_invoices'] ? ($sum['sales'] / $sum['count_invoices']) : 0;
$sum['avg_items'] = $sum['count_invoices'] ? ($sum['items'] / $sum['count_invoices']) : 0;

/** تصدير CSV */
if (isset($_GET['export']) && $_GET['export']==='csv'){
  csv_export('sales_summary.csv', array_keys($sum), [$sum]);
}
?>
<div class="panel p-3">
  <?php if(!$hasSales && !$hasDaily): ?>
    <div class="alert alert-warning">لا توجد جداول مبيعات بعد. سيعمل التقرير تلقائيًا عند إنشاء جداول <code>sales</code> (أو <code>dailyshiftsales</code> تقريبيًا).</div>
  <?php endif; ?>

  <form class="row g-2 align-items-end">
    <div class="col-md-3">
      <label class="form-label">من</label>
      <input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($df) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">إلى</label>
      <input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($dt) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id">
        <option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?>
          <option value="<?= (int)$id ?>" <?= $branch_id!=='' && (int)$branch_id===$id?'selected':''; ?>>
            <?= htmlspecialchars($nm) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>">CSV</a>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form>

  <hr>
  <div class="row g-3 text-center">
    <div class="col-md-3">
      <div class="panel p-3">
        <div class="text-muted">إجمالي المبيعات</div>
        <div class="fs-5 fw-bold"><?= money($sum['sales']) ?></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="panel p-3">
        <div class="text-muted">إجمالي المرتجعات</div>
        <div class="fs-5 fw-bold"><?= money($sum['returns']) ?></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="panel p-3">
        <div class="text-muted">صافي الفترة</div>
        <div class="fs-5 fw-bold"><?= money($sum['net']) ?></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="panel p-3">
        <div class="text-muted">عدد الفواتير</div>
        <div class="fs-5 fw-bold"><?= (int)$sum['count_invoices'] ?></div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="panel p-3">
        <div class="text-muted">متوسط قيمة الفاتورة</div>
        <div class="fs-6 fw-bold"><?= money($sum['avg_invoice']) ?></div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="panel p-3">
        <div class="text-muted">إجمالي عدد القطع</div>
        <div class="fs-6 fw-bold"><?= (int)$sum['items'] ?></div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="panel p-3">
        <div class="text-muted">متوسط قطع/فاتورة</div>
        <div class="fs-6 fw-bold"><?= number_format($sum['avg_items'],2) ?></div>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
