<?php
require_once __DIR__ . '/_init.php';
$title='التكلفة المتوسطة المتحركة (تقريبي)';
include __DIR__.'/_layout_top.php';

$hasCreated = hasColumn($pdo,'inventory_movements','created_at');
$date_from=param('date_from',''); $date_to=param('date_to','');

if (!$hasCreated){
  echo '<div class="panel p-3 alert alert-warning">لا يمكن حساب التكلفة المتوسطة المتحركة دون عمود <code>created_at</code> في <code>inventory_movements</code>.</div>';
  include __DIR__.'/_layout_bottom.php'; exit;
}

/* فلاتر */
$where=[]; $params=[];
if($date_from!==''){ $where[]="DATE(m.created_at)>=:df"; $params[':df']=$date_from; }
if($date_to!==''){ $where[]="DATE(m.created_at)<=:dt"; $params[':dt']=$date_to; }
$whereSQL = $where ? 'WHERE '.implode(' AND ',$where) : '';

/* نجيب الحركات مرتبة زمنيًا ونحسب متوسطًا تراكمياً بسيطًا (تقريب): 
   - أي كمية موجبة (purchase/sales_return/transfer_in/adjustment+) تدخل في المتوسط.
   - كمية سالبة تقلل المخزون لكن لا تغيّر تكلفة الوحدة (نستخدم آخر متوسط). */
$sql="SELECT m.variant_id, v.sku, p.name_ar AS product_name, m.qty_change, m.unit_cost, m.created_at
      FROM inventory_movements m
      JOIN product_variants v ON v.id=m.variant_id
      JOIN products p ON p.id=v.product_id
      $whereSQL
      ORDER BY m.variant_id, m.created_at, m.id
      LIMIT 50000";
$st=$pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll(PDO::FETCH_ASSOC);

$calc=[];
foreach($rows as $r){
  $vid=(int)$r['variant_id']; $q=(int)$r['qty_change']; $c=(float)$r['unit_cost'];
  if(!isset($calc[$vid])){
    $calc[$vid]=['sku'=>$r['sku'],'product_name'=>$r['product_name'],'qty'=>0,'mac'=>0.0];
  }
  $curQty = $calc[$vid]['qty'];
  $curMac = $calc[$vid]['mac'];

  if ($q>0){
    // مزج متوسط: (كمية قديمة * MAC + كمية جديدة * سعرها) / (الإجمالي)
    $newQty = $curQty + $q;
    $newMac = ($curQty*$curMac + $q*$c) / max(1, $newQty);
    $calc[$vid]['qty'] = $newQty;
    $calc[$vid]['mac'] = $newMac;
  } else {
    $calc[$vid]['qty'] = max(0, $curQty + $q); // نقص
    // MAC لا يتغير في السحب
  }
}

/* جهّز جدول */
$rowsOut=[];
foreach($calc as $vid=>$c){
  $rowsOut[]=[
    'product_name'=>$c['product_name'],
    'sku'=>$c['sku'],
    'ending_qty'=>$c['qty'],
    'moving_avg_cost'=>round($c['mac'], 4),
    'ending_value'=>round($c['qty']*$c['mac'], 2)
  ];
}
usort($rowsOut, fn($a,$b)=> ($b['ending_value']<=>$a['ending_value']));

if (isset($_GET['export']) && $_GET['export']==='csv'){
  csv_export('moving_average_cost.csv',['product_name','sku','ending_qty','moving_avg_cost','ending_value'],$rowsOut);
}
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-4"><label class="form-label">من</label><input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($date_from) ?>"></div>
    <div class="col-md-4"><label class="form-label">إلى</label><input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($date_to) ?>"></div>
    <div class="col-md-4 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>">CSV</a>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form><hr>

  <div class="table-responsive">
    <table class="table table-hover text-center align-middle">
      <thead class="table-light"><tr><th>الصنف</th><th>SKU</th><th>كمية ختامية</th><th>MAC (تكلفة متوسطة)</th><th>قيمة ختامية</th></tr></thead>
      <tbody>
        <?php if(!$rowsOut): ?><tr><td colspan="5" class="text-muted">لا توجد حركات في الفترة المحددة.</td></tr>
        <?php else: foreach($rowsOut as $r): ?>
          <tr>
            <td class="text-start"><?= htmlspecialchars($r['product_name']) ?></td>
            <td><?= htmlspecialchars($r['sku']) ?></td>
            <td><?= (int)$r['ending_qty'] ?></td>
            <td><?= money($r['moving_avg_cost']) ?></td>
            <td class="fw-bold"><?= money($r['ending_value']) ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>

  <div class="alert alert-secondary mt-3">
    صيغة تقريبية: يُعاد احتساب التكلفة المتوسطة عند كل حركة واردة فقط. السحوبات (مبيعات/تحويلات خارجة) لا تغيّر MAC.
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
