<?php
require_once __DIR__ . '/_init.php';
$title='تحليل أداء الفروع';
include __DIR__.'/_layout_top.php';

$date_from=param('date_from',''); $date_to=param('date_to','');
$brs=branches($pdo);

/* مشتريات لكل فرع */
$where=["p.deleted_at IS NULL"]; $params=[];
if($date_from!==''){ $where[]="p.order_date>=:df"; $params[':df']=$date_from; }
if($date_to!==''){ $where[]="p.order_date<=:dt"; $params[':dt']=$date_to; }
$whereSQL='WHERE '.implode(' AND ',$where);
$sql="SELECT b.BranchName, SUM(p.total) AS purchases_total
      FROM purchases p LEFT JOIN Branches b ON b.BranchID=p.branch_id
      $whereSQL
      GROUP BY b.BranchName";
$st=$pdo->prepare($sql); $st->execute($params); $purch=$st->fetchAll(PDO::FETCH_KEY_PAIR);

/* صافي تحويلات (داخل - خارج) */
$hasTrans = hasTable($pdo,'transfers') && hasTable($pdo,'transfer_items');
$netTrans = [];
if ($hasTrans){
  $ti = $pdo->query("SELECT t.from_branch_id, t.to_branch_id, SUM(qty) AS qty
                     FROM transfers t JOIN transfer_items i ON i.transfer_id=t.id
                     GROUP BY t.from_branch_id, t.to_branch_id")->fetchAll(PDO::FETCH_ASSOC);
  foreach($ti as $r){
    $from=(int)$r['from_branch_id']; $to=(int)$r['to_branch_id']; $q=(int)$r['qty'];
    $netTrans[$to] = ($netTrans[$to] ?? 0) + $q;
    $netTrans[$from] = ($netTrans[$from] ?? 0) - $q;
  }
}

/* تقييم مخزون بالتكلفة لكل فرع */
$inv = $pdo->query("SELECT b.BranchName,
      SUM(s.quantity * IFNULL((SELECT pi.unit_cost FROM purchase_items pi WHERE pi.variant_id=s.variant_id ORDER BY pi.id DESC LIMIT 1),0)) AS val
      FROM product_variant_stock s
      LEFT JOIN Branches b ON b.BranchID=s.branch_id
      GROUP BY b.BranchName")->fetchAll(PDO::FETCH_KEY_PAIR);

?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-4"><label class="form-label">من</label><input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($date_from) ?>"></div>
    <div class="col-md-4"><label class="form-label">إلى</label><input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($date_to) ?>"></div>
    <div class="col-md-4 d-flex gap-2"><button class="btn btn-brand">تطبيق</button><button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button></div>
  </form><hr>

  <div class="row g-3">
    <?php foreach($brs as $bid=>$bn): ?>
      <div class="col-md-6">
        <div class="panel p-3">
          <h6 class="mb-2"><i class="fa-solid fa-store"></i> <?= htmlspecialchars($bn) ?></h6>
          <div class="row g-3">
            <div class="col-6"><div class="panel p-2 text-center"><div class="text-muted">مشتريات الفترة</div><div class="fs-6 fw-bold"><?= money($purch[$bn] ?? 0) ?></div></div></div>
            <div class="col-6"><div class="panel p-2 text-center"><div class="text-muted">قيمة مخزون (تكلفة)</div><div class="fs-6 fw-bold"><?= money($inv[$bn] ?? 0) ?></div></div></div>
            <div class="col-12">
              <div class="panel p-2 text-center">
                <div class="text-muted">صافي التحويلات</div>
                <div class="fs-6 fw-bold">
                  <?php
                    if (!$hasTrans) echo '—';
                    else {
                      $net = $netTrans[$bid] ?? 0;
                      echo ($net>0?'<span class="text-success">+'.$net.'</span>':($net<0?'<span class="text-danger">'.$net.'</span>':'0'));
                    }
                  ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
