<?php
/* $title, $breadcrumbs يُمكن تمريرهم من الصفحة */
$title = $title ?? 'تقرير';
$breadcrumbs = $breadcrumbs ?? [['Dashboard','../dashboard.php'], ['التقارير','./']];
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= htmlspecialchars($title) ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
<style>
:root{ --bg:#f5f6f8; --card:#fff; --border:rgba(0,0,0,.08); --muted:#6b7280; --brand:#1abc9c; }
body{background:var(--bg); font-family:"Tajawal", Tahoma, Arial, sans-serif}
header{background:linear-gradient(120deg,#0f2027,#203a43,#2c5364); color:#fff; padding:12px 18px; margin-bottom:16px}
.panel{background:var(--card); border:1px solid var(--border); border-radius:14px; box-shadow:0 8px 24px rgba(0,0,0,.06)}
.table>:not(caption)>*>*{background:transparent}
.badge-soft{background:#ecfdf5;color:#065f46}
h1 small{font-size:.6em; color:#cbd5e1}
.btn-brand{background:var(--brand); color:#fff; border:none}
.btn-brand:hover{filter:brightness(.9)}
.form-inline .form-control, .form-inline .form-select{min-width:160px}
</style>
</head>
<body>
<header class="d-flex align-items-center justify-content-between">
  <div class="d-flex align-items-center gap-2">
    <a href="../dashboard.php" class="btn btn-light btn-sm"><i class="fa-solid fa-house"></i></a>
    <h1 class="h5 m-0"><?= htmlspecialchars($title) ?> <small>التقارير</small></h1>
  </div>
  <div class="d-flex align-items-center gap-2">
    <a href="../dashboard.php" class="btn btn-light btn-sm">لوحة التحكم</a>
    <a href="../logout.php" class="btn btn-outline-light btn-sm">خروج</a>
  </div>
</header>
<div class="container">
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <?php foreach($breadcrumbs as $b): ?>
        <li class="breadcrumb-item">
          <?php if (isset($b[1])): ?><a href="<?= htmlspecialchars($b[1]) ?>"><?= htmlspecialchars($b[0]) ?></a>
          <?php else: ?><?= htmlspecialchars($b[0]) ?><?php endif; ?>
        </li>
      <?php endforeach; ?>
      <li class="breadcrumb-item active" aria-current="page"><?= htmlspecialchars($title) ?></li>
    </ol>
  </nav>
